<?php
/**
 * Plumrocket Inc.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 * that is available through the world-wide-web at this URL:
 * http://wiki.plumrocket.net/wiki/EULA
 * If you are unable to obtain it through the world-wide-web, please
 * send an email to support@plumrocket.com so we can send you a copy immediately.
 *
 * @package     Plumrocket_Amp 2.x.x
 * @copyright   Copyright (c) 2016 Plumrocket Inc. (http://www.plumrocket.com)
 * @license     http://wiki.plumrocket.net/wiki/EULA  End-user License Agreement
 */

namespace Plumrocket\Amp\Block\Page\Head\Og;

class Cms extends AbstractOg
{
    /**
     * Retrieve additional data
     * @return array
     */
    public function getOgParams()
    {
        $params = parent::getOgParams();
        return array_merge($params, [
            'type' => 'website',
            'url' => $this->_helper->getCanonicalUrl(
                $this->getUrl('*/*/*', ['_current' => true, '_use_rewrite' => true])
            ),
        ]);
    }
}
