<?php
namespace Magento\Catalog\Model\Category\Attribute\LayoutUpdateManager;

/**
 * Proxy class for @see \Magento\Catalog\Model\Category\Attribute\LayoutUpdateManager
 */
class Proxy extends \Magento\Catalog\Model\Category\Attribute\LayoutUpdateManager implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Magento\Catalog\Model\Category\Attribute\LayoutUpdateManager
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Magento\\Catalog\\Model\\Category\\Attribute\\LayoutUpdateManager', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Magento\Catalog\Model\Category\Attribute\LayoutUpdateManager
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function fetchAvailableFiles(\Magento\Catalog\Api\Data\CategoryInterface $category) : array
    {
        return $this->_getSubject()->fetchAvailableFiles($category);
    }

    /**
     * {@inheritdoc}
     */
    public function extractCustomSettings(\Magento\Catalog\Api\Data\CategoryInterface $category, \Magento\Framework\DataObject $intoSettings) : void
    {
        $this->_getSubject()->extractCustomSettings($category, $intoSettings);
    }
}
