<?php
namespace Magento\Framework\Notification\NotifierInterface;

/**
 * Proxy class for @see \Magento\Framework\Notification\NotifierInterface
 */
class Proxy implements \Magento\Framework\Notification\NotifierInterface, \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Magento\Framework\Notification\NotifierInterface
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Magento\\Framework\\Notification\\NotifierInterface', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Magento\Framework\Notification\NotifierInterface
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function add($severity, $title, $description, $url = '', $isInternal = true)
    {
        return $this->_getSubject()->add($severity, $title, $description, $url, $isInternal);
    }

    /**
     * {@inheritdoc}
     */
    public function addCritical($title, $description, $url = '', $isInternal = true)
    {
        return $this->_getSubject()->addCritical($title, $description, $url, $isInternal);
    }

    /**
     * {@inheritdoc}
     */
    public function addMajor($title, $description, $url = '', $isInternal = true)
    {
        return $this->_getSubject()->addMajor($title, $description, $url, $isInternal);
    }

    /**
     * {@inheritdoc}
     */
    public function addMinor($title, $description, $url = '', $isInternal = true)
    {
        return $this->_getSubject()->addMinor($title, $description, $url, $isInternal);
    }

    /**
     * {@inheritdoc}
     */
    public function addNotice($title, $description, $url = '', $isInternal = true)
    {
        return $this->_getSubject()->addNotice($title, $description, $url, $isInternal);
    }
}
