<?php
/**
 * Plumrocket Inc.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 * that is available through the world-wide-web at this URL:
 * http://wiki.plumrocket.net/wiki/EULA
 * If you are unable to obtain it through the world-wide-web, please
 * send an email to support@plumrocket.com so we can send you a copy immediately.
 *
 * @package     Plumrocket_Base
 * @copyright   Copyright (c) 2020 Plumrocket Inc. (http://www.plumrocket.com)
 * @license     http://wiki.plumrocket.net/wiki/EULA  End-user License Agreement
 */

declare(strict_types=1);

namespace Plumrocket\Base\Model\Extensions\Config;

use Magento\Framework\Config\ConverterInterface;
use Magento\Framework\Data\Argument\Interpreter\Boolean as BooleanInterpreter;

class Converter implements ConverterInterface
{
    /**
     * @var BooleanInterpreter
     */
    private $booleanInterpreter;

    /**
     * @param \Magento\Framework\Data\Argument\Interpreter\Boolean $booleanInterpreter
     */
    public function __construct(BooleanInterpreter $booleanInterpreter)
    {
        $this->booleanInterpreter = $booleanInterpreter;
    }

    /**
     * Convert dom node tree to array
     *
     * @param \DOMDocument $source
     * @return array
     */
    public function convert($source)
    {
        $output = [];
        /** @var \DOMNodeList $cookies */
        $cookies = $source->getElementsByTagName('extension');
        /** @var \DOMNode $cookie */
        foreach ($cookies as $cookie) {
            $extensionConfig = [
                'config_section' => '',
                'is_enabled_path' => '',
                'wiki' => '',
                'is_service' => false,
            ];
            /** @var \DOMAttr $attribute */
            foreach ($cookie->attributes as $attribute) {
                $value = $attribute->nodeValue;
                if ($attribute->nodeName === 'is_service') {
                    $value = $this->booleanInterpreter->evaluate(['value' => $value]);
                }
                $extensionConfig[$attribute->nodeName] = $value;
            }

            $output[$cookie->attributes->getNamedItem('name')->nodeValue] = $extensionConfig;
        }

        return ['extensions' => $output];
    }
}
